/*----------------------------------------------------------------------
 | TYPE.H							940420
 |
 | Contains all type definitions.
 +----------------------------------------------------------------------*/


#include "const.h"

typedef Unsigned1 Boolean;
typedef Signed2 ValueType;

typedef Unsigned1 SquareType;   /* Needs at least 8 bits */
typedef Unsigned2 BoardIndexType;
typedef Signed2 DirectionType;

typedef Unsigned4 HashType[2];

typedef struct _CheckPieceType {
    BoardIndexType  square;
    DirectionType   dir;
}
                CheckPieceType;

typedef struct _PieceType {
    BoardIndexType  square;
    SquareType      type;
}
                PieceType;

typedef struct _MoveType {
    BoardIndexType  from,
                    to;
    SquareType      capturedPiece;
    SquareType      promotionPiece;
    Unsigned1       type;
}
                MoveType;

typedef struct _PathType {
    char            moveString[MaxMoveLength];
    MoveType        move;
    struct _PathType *next;
}
                PathType;

typedef struct _History {
    BoardIndexType  from,
                    to;
    Unsigned2       nr;
}
                History;

typedef struct _TtEntry {
    Unsigned4       lockPlyDepthFlag;
    Unsigned4       lockRemainder;
    Unsigned4       fromToPromTypeVal;
    Unsigned4       nrNodes;
    Unsigned1       ply;
}
                TtEntry;
